<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\Subscription;

class StatusMapper
{
    public const TRIAL = 'trialing';
    public const ACTIVE = 'active';
    public const CANCELED = 'canceled';
    public const INCOMPLETE_EXPIRED = 'incomplete_expired';
    public const PAST_DUE = 'past_due';

    public function getStatus(string $status): string
    {
        $names = [
            self::TRIAL              => __('Trial'),
            self::ACTIVE             => __('Active'),
            self::CANCELED           => __('Canceled'),
            self::INCOMPLETE_EXPIRED => __('Incomplete And Expired'),
            self::PAST_DUE           => __('Past Due')
        ];

        return (string)($names[$status] ?? $status);
    }
}
