<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\Subscription\Processors;

use Amasty\RecurringPayments\Api\Subscription\CancelProcessorInterface;
use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringStripe\Model\StripeAdapterProvider;

class Cancel implements CancelProcessorInterface
{
    /**
     * @var StripeAdapterProvider
     */
    private $adapterProvider;

    public function __construct(StripeAdapterProvider $adapterProvider)
    {
        $this->adapterProvider = $adapterProvider;
    }

    /**
     * @param SubscriptionInterface $subscription
     */
    public function process(SubscriptionInterface $subscription): void
    {
        $adapter = $this->adapterProvider->get();
        /** @var \Stripe\Subscription $stripeSubscription */
        $stripeSubscription = $adapter->subscriptionRetrieve($subscription->getSubscriptionId());
        $stripeSubscription->delete();
    }
}
