<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model;

use Amasty\Stripe\Gateway\Config\Config as StripeConfig;

class StripeAdapterProvider
{
    /**
     * @var Adapter
     */
    private $stripeAdapter;

    /**
     * @var StripeConfig
     */
    private $stripeConfig;

    /**
     * @var array
     */
    private $adapterByStore = [];

    public function __construct(Adapter $stripeAdapter, StripeConfig $stripeConfig)
    {
        $this->stripeAdapter = $stripeAdapter;
        $this->stripeConfig = $stripeConfig;
    }

    /**
     * @param int|null $storeId
     * @return Adapter
     */
    public function get(int $storeId = null): Adapter
    {
        if (!empty($this->adapterByStore[$storeId])) {
            return $this->adapterByStore[$storeId];
        }

        $apiKey = $this->stripeConfig->getPrivateKey($storeId);
        $this->adapterByStore[$storeId] = $this->stripeAdapter->initCredentials($apiKey);

        return $this->adapterByStore[$storeId];
    }
}
