<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\Processors;

use Amasty\RecurringStripe\Api\Data\ProductInterface;
use Amasty\RecurringStripe\Api\ProductRepositoryInterface;
use Amasty\RecurringStripe\Model\StripeAdapterProvider;
use Amasty\RecurringStripe\Model\StripeProduct;
use Amasty\RecurringStripe\Model\StripeProductFactory;
use Magento\Quote\Api\Data\CartItemInterface;

class CreateProduct extends AbstractProcessor
{
    /**
     * @var StripeProductFactory
     */
    private $stripeProductFactory;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    public function __construct(
        StripeAdapterProvider $adapterProvider,
        StripeProductFactory $stripeProductFactory,
        ProductRepositoryInterface $productRepository
    ) {
        parent::__construct($adapterProvider);
        $this->stripeProductFactory = $stripeProductFactory;
        $this->productRepository = $productRepository;
    }

    /**
     * @param CartItemInterface $item
     * @param int $productId
     *
     * @return ProductInterface
     */
    public function execute(CartItemInterface $item, int $productId): ProductInterface
    {
        $params = [
            'name' => $item->getName(),
            'type' => 'service',
        ];

        $adapter = $this->adapterProvider->get();
        /** @var \Stripe\Product $product */
        $product = $adapter->productCreate($params);

        /** @var StripeProduct $stripeProduct */
        $stripeProduct = $this->stripeProductFactory->create();
        $stripeProduct->setProductId($productId);
        $stripeProduct->setStripeProductId($product->id);
        $stripeProduct->setStripeAccountId($adapter->getAccountId());

        return $this->productRepository->save($stripeProduct);
    }
}
