<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\Processors;

use Amasty\RecurringPayments\Model\Amount;
use Magento\Quote\Api\Data\CartItemInterface;

class CreateCoupon extends AbstractProcessor
{
    /**
     * @param CartItemInterface $item
     * @param float $discountAmount
     * @return \Stripe\StripeObject|null
     */
    public function execute(CartItemInterface $item, float $discountAmount)
    {
        $adapter = $this->adapterProvider->get();
        $params = [
            'duration'        => 'forever',
            'currency'        => $item->getQuote()->getBaseCurrencyCode(),
            'max_redemptions' => 1,
            'amount_off'      => $discountAmount * Amount::PERCENT
        ];

        return $adapter->couponCreate($params);
    }
}
