<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\IpnHandlers\Invoice;

use Amasty\RecurringPayments\Model\Config\Source\Status;

class PaymentFailed extends AbstractInvoice
{
    /**
     * @inheritDoc
     */
    public function process(\Stripe\Event $event)
    {
        $this->saveTransactionLog($event, Status::FAILED);
    }
}
