<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model\IpnHandlers\Customer\Subscription;

use Amasty\RecurringPayments\Api\Subscription\RepositoryInterface;
use Amasty\RecurringPayments\Model\Config;
use Amasty\RecurringPayments\Model\Subscription\Email\EmailNotifier;
use Amasty\RecurringPayments\Model\Subscription\Operation\TrialWillEndOperation;
use Amasty\RecurringStripe\Model\IpnHandlers\AbstractIpnHandler;

class TrialWillEnd extends AbstractIpnHandler
{
    /**
     * @var TrialWillEndOperation
     */
    private $trialWillEndOperation;

    public function __construct(
        Config $config,
        EmailNotifier $emailNotifier,
        RepositoryInterface $subscriptionRepository,
        TrialWillEndOperation $trialWillEndOperation
    ) {
        parent::__construct($config, $emailNotifier, $subscriptionRepository);
        $this->trialWillEndOperation = $trialWillEndOperation;
    }

    /**
     * @param \Stripe\Event $event
     */
    public function process(\Stripe\Event $event)
    {
        $subscription = $this->getSubscription($event);
        if (!$subscription || !$subscription->getTrialDays()) {
            return;
        }

        $this->trialWillEndOperation->execute($subscription);
    }
}
