<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model;

use Amasty\RecurringStripe\Api\IpnHandlerInterface;
use Amasty\RecurringStripe\Api\IpnInterface;

class Ipn implements IpnInterface
{
    /**
     * @var IpnHandlerInterface[]
     */
    private $ipnHandlers;

    public function __construct(array $ipnHandlers)
    {
        $this->ipnHandlers = $ipnHandlers;
    }

    /**
     * @param \Stripe\Event $event
     *
     * @throws \Exception
     */
    public function processIpnRequest(\Stripe\Event $event)
    {
        if (!isset($this->ipnHandlers[$event->type])) {
            throw new \RuntimeException(sprintf('Stripe event %s is not supported', $event->type));
        }

        $this->ipnHandlers[$event->type]->process($event);
    }
}
