<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Model;

use Amasty\Stripe\Gateway\Config\Config;

class ConfigWebhook extends Config
{
    public const WEBHOOK_SECRET = 'webhook_secret';

    /**
     * @return string
     */
    public function getWebhookSecret(): string
    {
        return $this->encryptor->decrypt($this->getValue(self::WEBHOOK_SECRET));
    }
}
