<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Api\Data;

interface ProductInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const ENTITY_ID = 'entity_id';
    public const PRODUCT_ID = 'product_id';
    public const STRIPE_PRODUCT_ID = 'stripe_product_id';
    public const STRIPE_ACCOUNT_ID = 'stripe_account_id';
    /**#@-*/

    /**
     * @return int
     */
    public function getEntityId();

    /**
     * @param int $entityId
     *
     * @return ProductInterface
     */
    public function setEntityId($entityId);

    /**
     * @return int|null
     */
    public function getProductId();

    /**
     * @param int|null $productId
     *
     * @return ProductInterface
     */
    public function setProductId($productId);

    /**
     * @return string|null
     */
    public function getStripeProductId();

    /**
     * @param string|null $stripeProductId
     *
     * @return ProductInterface
     */
    public function setStripeProductId($stripeProductId);

    /**
     * @return string|null
     */
    public function getStripeAccountId();

    /**
     * @param string|null $stripeAccountId
     *
     * @return ProductInterface
     */
    public function setStripeAccountId($stripeAccountId);
}
