<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Api;

use Amasty\Stripe\Api\CustomerRepositoryInterface as StripeCustomerRepository;
use Amasty\Stripe\Api\Data\CustomerInterface;

/**
 * @api
 */
interface CustomerRepositoryInterface extends StripeCustomerRepository
{
    /**
     * @param string $stripeId
     *
     * @return CustomerInterface
     */
    public function getByStripeId(string $stripeId): CustomerInterface;
}
