<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Plugin\Backend\Model\Menu;

use Magento\Backend\Model\Menu;
use Magento\Backend\Model\Menu\Builder as MenuBuilder;

/**
 * Class Builder
 * Hides modules's menu from Amasty menu
 */
class Builder
{
    public const MENU_ID = 'Amasty_RecurringPaypal::container';

    /**
     * @param MenuBuilder $subject
     * @param Menu $menu
     * @return Menu
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetResult(MenuBuilder $subject, Menu $menu)
    {
        $menu->remove(self::MENU_ID);

        return $menu;
    }
}
