<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Model\WebHook\Handler\Billing\Subscription;

use Amasty\RecurringPaypal\Api\WebHook\HandlerInterface;
use Amasty\RecurringPaypal\Model\WebHook\Handler\Billing\Subscription;

class Created extends Subscription implements HandlerInterface
{
    /**
     * @param array $payload
     */
    public function process(array $payload)
    {
        if (!($subscription = $this->getSubscription($payload))) {
            return;
        }

        $this->clearCache((string)$subscription->getSubscriptionId());

        if ($this->config->isNotifySubscriptionPurchased((int)$subscription->getStoreId())) {
            $template = $this->config->getEmailTemplateSubscriptionPurchased((int)$subscription->getStoreId());
            $this->sendNotification($subscription, $template);
        }
    }
}
