<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Model\Subscription;

class StatusMapper
{
    public const APPROVAL_PENDING = 'APPROVAL_PENDING';
    public const ACTIVE = 'ACTIVE';
    public const CANCELLED = 'CANCELLED';

    public function getStatus(string $status): string
    {
        $names = [
            self::APPROVAL_PENDING => __('Approval Pending'),
            self::ACTIVE           => __('Active'),
            self::CANCELLED        => __('Cancelled'),
        ];

        return (string)($names[$status] ?? $status);
    }
}
