<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Model\Subscription\Processors;

use Amasty\RecurringPayments\Api\Subscription\CancelProcessorInterface;
use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringPaypal\Model\Api\Adapter;
use Amasty\RecurringPaypal\Model\Subscription\Cache as SubscriptionCache;

class Cancel implements CancelProcessorInterface
{
    /**
     * @var Adapter
     */
    private $adapter;

    /**
     * @var SubscriptionCache
     */
    private $subscriptionCache;

    public function __construct(
        Adapter $adapter,
        SubscriptionCache $subscriptionCache
    ) {
        $this->adapter = $adapter;
        $this->subscriptionCache = $subscriptionCache;
    }

    /**
     * @param SubscriptionInterface $subscription
     */
    public function process(SubscriptionInterface $subscription): void
    {
        $this->adapter->cancelSubscription($subscription->getSubscriptionId(), (string)__('Cancelled by customer'));
        $this->subscriptionCache->clearSubscriptionData($subscription->getSubscriptionId());
    }
}
