<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Model\Subscription\Confirmation;

use Magento\Framework\Session\SessionManagerInterface;

class LinksPersistor
{
    public const REDIRECT_URL_KEY = 'amasty_recurring_redirect_url';

    /**
     * @var SessionManagerInterface
     */
    private $sessionManager;

    public function __construct(
        SessionManagerInterface $sessionManager
    ) {
        $this->sessionManager = $sessionManager;
    }

    public function push(string $link)
    {
        $data = $this->sessionManager->getData(self::REDIRECT_URL_KEY) ?: [];
        $data[] = $link;
        $this->sessionManager->setData(self::REDIRECT_URL_KEY, $data);
    }

    public function pop(): string
    {
        $result = '';
        $data = $this->sessionManager->getData(self::REDIRECT_URL_KEY);
        if (is_array($data) && !empty($data)) {
            $result = array_shift($data);
            if (!empty($data)) {
                $this->sessionManager->setData(self::REDIRECT_URL_KEY, $data);
            } else {
                $this->sessionManager->unsetData(self::REDIRECT_URL_KEY);
            }
        }

        return $result;
    }
}
