<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Paypal (System)
 */

namespace Amasty\RecurringPaypal\Model\Processor;

use Magento\Framework\Pricing\PriceCurrencyInterface;

class PaypalCurrencyRound
{
    public const INTEGER_CURRENCIES = [
        'HUF',
        'JPY',
        'TWD',
    ];

    /**
     * @param float $amount
     * @param string $currencyCode
     * @return false|float
     */
    public function round(float $amount, string $currencyCode)
    {
        $precision = PriceCurrencyInterface::DEFAULT_PRECISION;

        if (in_array($currencyCode, self::INTEGER_CURRENCIES)) {
            $precision = 0;
        }

        // @TODO change to PriceCurrencyInterface::roundPrice($amount, $currencyCode) if it appeared in interface
        return round($amount, $precision);
    }
}
