<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments Cash on Delivery for Magento 2 (System)
 */

namespace Amasty\RecurringCashOnDelivery\Model\Subscription\Create;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringPayments\Model\Subscription\Create\CreateSubscriptionHandlerInterface;
use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\Sales\Api\Data\OrderInterface;

class CreateSubscriptionHandler implements CreateSubscriptionHandlerInterface
{
    public const SUBSCRIPTION_PREFIX = 'sub_';

    /**
     * @param OrderInterface $order
     * @param AbstractItem $item
     * @param SubscriptionInterface $subscription
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function handle(OrderInterface $order, AbstractItem $item, SubscriptionInterface $subscription): void
    {
        $subscriptionId = uniqid(self::SUBSCRIPTION_PREFIX, true);
        $subscription->setSubscriptionId($subscriptionId);
    }
}
