<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments Cash on Delivery for Magento 2 (System)
 */

namespace Amasty\RecurringCashOnDelivery\Model\Processor;

use Amasty\RecurringCashOnDelivery\Model\Processor\Transaction\TransactionGeneratorPart;
use Amasty\RecurringPayments\Api\Processors\HandleSubscriptionInterface;
use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringPayments\Model\Subscription\HandleOrder\CompositeHandler;
use Amasty\RecurringPayments\Model\Subscription\HandleOrder\CompositeHandlerFactory;
use Amasty\RecurringPayments\Model\Subscription\HandleOrder\HandleOrderContext;
use Amasty\RecurringPayments\Model\Subscription\HandleOrder\HandleOrderContextFactory;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Store\Model\App\Emulation;
use Magento\Store\Model\StoreManagerInterface;

class HandleSubscriptionCharge implements HandleSubscriptionInterface
{
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * @var Emulation
     */
    private $emulation;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var CompositeHandlerFactory
     */
    private $compositeHandlerFactory;

    /**
     * @var HandleOrderContextFactory
     */
    private $handleOrderContextFactory;

    /**
     * @var TransactionGeneratorPart
     */
    private $transactionGeneratorPart;

    public function __construct(
        OrderRepositoryInterface $orderRepository,
        Emulation $emulation,
        StoreManagerInterface $storeManager,
        CompositeHandlerFactory $compositeHandlerFactory,
        HandleOrderContextFactory $handleOrderContextFactory,
        TransactionGeneratorPart $transactionGeneratorPart
    ) {
        $this->orderRepository = $orderRepository;
        $this->emulation = $emulation;
        $this->storeManager = $storeManager;
        $this->compositeHandlerFactory = $compositeHandlerFactory;
        $this->handleOrderContextFactory = $handleOrderContextFactory;
        $this->transactionGeneratorPart = $transactionGeneratorPart;
    }

    /**
     * @param SubscriptionInterface $subscription
     */
    public function process(SubscriptionInterface $subscription)
    {
        $order = $this->orderRepository->get($subscription->getOrderId());

        $this->emulation->startEnvironmentEmulation($order->getStoreId());
        $this->storeManager->getStore()->setCurrentCurrencyCode($order->getOrderCurrencyCode());

        /** @var HandleOrderContext $handleOrderContext */
        $handleOrderContext = $this->handleOrderContextFactory->create();
        $handleOrderContext->setSubscription($subscription);
        /** @var CompositeHandler $compositeHandler */
        $compositeHandler = $this->compositeHandlerFactory->create();
        $compositeHandler->addPart($this->transactionGeneratorPart, 'cashondelivery_transaction', 'quote');
        $compositeHandler->handle($handleOrderContext);

        if ($subscription->getRemainingDiscountCycles() > 0) {
            $subscription->setRemainingDiscountCycles(
                $subscription->getRemainingDiscountCycles() - 1
            );
        }

        $this->emulation->stopEnvironmentEmulation();
    }
}
