<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments Cash on Delivery for Magento 2 (System)
 */

namespace Amasty\RecurringCashOnDelivery\Model\Config;

use Amasty\RecurringPayments\Api\Config\ValidatorInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class ConfigurationValidator implements ValidatorInterface
{
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @inheritDoc
     */
    public function enumerateConfigurationIssues(): \Generator
    {
        if (!$this->scopeConfig->isSetFlag('payment/cashondelivery/active', ScopeInterface::SCOPE_STORE)) {
            yield __('Cash On Delivery payment method is not enabled');
        }
    }
}
