<?php

declare(strict_types=1);

namespace Amasty\QuoteAttributesManagement\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Model\System\Store;

class StoreOptions implements OptionSourceInterface
{
    /**
     * @var Store
     */
    private $store;

    /**
     * @param Store $store
     */
    public function __construct(Store $store)
    {
        $this->store = $store;
    }

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return $this->store->getStoreValuesForForm(false, true);
    }
}
