<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Request a Quote Attributes for Magento 2 (System)
 */

namespace Amasty\QuoteAttributes\Block\Adminhtml\Quote\Edit;

use Amasty\QuoteAttributes\Block\Data\Form\Element\Boolean;
use Amasty\QuoteAttributes\Model\QuoteEntity\GetAttributeList;
use Amasty\QuoteAttributes\Model\Source\Attribute\FrontendInput;
use Amasty\RequestQuote\Api\Data\QuoteInterface;
use Amasty\RequestQuote\Block\Adminhtml\Quote\Edit\Tab\Info;
use Amasty\RequestQuote\Model\Quote\Backend\Session as BackendSession;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic as FormGeneric;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;

class Attributes extends FormGeneric
{
    public const QUOTE_ENTITY_SCOPE = 'quote_entity';

    /**
     * @var GetAttributeList
     */
    private $getAttributeList;

    /**
     * @var QuoteInterface|null
     */
    private $quote;

    /**
     * @var BackendSession
     */
    private $backendSession;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        BackendSession $backendSession,
        GetAttributeList $getAttributeList,
        array $data = []
    ) {
        parent::__construct($context, $registry, $formFactory, $data);
        $this->getAttributeList = $getAttributeList;
        $this->backendSession = $backendSession;
    }

    protected function _prepareForm(): Attributes
    {
        if ($this->getQuote() && $quoteEntity = $this->getQuote()->getExtensionAttributes()->getQuoteEntity()) {
            $form = $this->_formFactory->create(
                [
                    'data' => [
                        'id' => 'edit_form',
                        'action' => $this->getData('action'),
                        'method' => 'post',
                        'enctype' => 'multipart/form-data'
                    ]
                ]
            );

            $form->setUseContainer(false);
            $form->setFieldNameSuffix(self::QUOTE_ENTITY_SCOPE);

            $fieldset = $form->addFieldset('base_fieldset', [
                'collapsable' => false
            ]);

            $this->_setFieldset($this->getAttributeList->execute($quoteEntity), $fieldset);

            $this->setForm($form);
        }

        return parent::_prepareForm();
    }

    protected function _initFormValues(): Attributes
    {
        if ($this->getQuote() && $quoteEntity = $this->getQuote()->getExtensionAttributes()->getQuoteEntity()) {
            $form = $this->getForm();
            foreach ($this->getAttributeList->execute($quoteEntity) as $attribute) {
                $value = $quoteEntity->hasData($attribute->getAttributeCode())
                    ? $quoteEntity->getData($attribute->getAttributeCode())
                    : $attribute->getDefaultValue();
                $form->getElement($attribute->getAttributeCode())->setValue($value);
            }
        }

        return parent::_initFormValues();
    }

    private function getQuote(): ?QuoteInterface
    {
        if ($this->quote === null && $this->getParentBlock()) {
            $parentBlock = $this->getParentBlock();
            if ($parentBlock instanceof Info) {
                $this->quote = $parentBlock->getSource();
            } else {
                $this->quote = $this->backendSession->getQuote();
            }
        }

        return $this->quote;
    }

    protected function _getAdditionalElementTypes(): array
    {
        return [
            FrontendInput::BOOLEAN => Boolean::class
        ];
    }
}
