<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Push Notifications for Magento 2
 */

namespace Amasty\PushNotifications\Observer\Customer;

use Amasty\PushNotifications\Api\SubscriberRepositoryInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class DeleteSubscriber implements ObserverInterface
{
    /**
     * @var SubscriberRepositoryInterface
     */
    private $subscriberRepository;

    public function __construct(
        SubscriberRepositoryInterface $subscriberRepository
    ) {
        $this->subscriberRepository = $subscriberRepository;
    }

    public function execute(Observer $observer): void
    {
        $this->subscriberRepository->deleteByCustomerId((int)$observer->getCustomer()->getId());
    }
}
