<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Push Notifications for Magento 2
 */

namespace Amasty\PushNotifications\Cron;

use Amasty\PushNotifications\Exception\NotificationException;
use Amasty\PushNotifications\Model\ConfigProvider;
use Amasty\PushNotifications\Model\Processor\CampaignProcessor;
use Psr\Log\LoggerInterface;

class SendNotifications
{
    /**
     * @var CampaignProcessor
     */
    private $campaignProcessor;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        CampaignProcessor $campaignProcessor,
        LoggerInterface $logger,
        ConfigProvider $configProvider
    ) {
        $this->campaignProcessor = $campaignProcessor;
        $this->logger = $logger;
        $this->configProvider = $configProvider;
    }

    public function execute(): SendNotifications
    {
        if (!$this->configProvider->isModuleEnable()) {
            return $this;
        }

        try {
            $this->campaignProcessor->processBySchedule();
        } catch (NotificationException $exception) {
            $this->logger->warning($exception->getMessage());
        }

        return $this;
    }
}
