<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Setup\Patch\Data;

use Amasty\PromoCountdown\Block\Widgets\Countdown;
use Amasty\PromoCountdown\Model\Active;
use Amasty\PromoCountdown\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddActiveSetting implements DataPatchInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var Active
     */
    private $activeSetting;

    /**
     * @var State
     */
    private $state;

    public function __construct(
        CollectionFactory $collectionFactory,
        Active $activeSetting,
        State $state
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->activeSetting = $activeSetting;
        $this->state = $state;
    }

    /**
     * @throws \Exception
     */
    public function apply(): void
    {
        $collection = $this->collectionFactory->create()
            ->addFieldToFilter('instance_type', Countdown::class);

        foreach ($collection->getItems() as $widgetInstance) {
            $this->state->emulateAreaCode(
                Area::AREA_FRONTEND,
                [$this->activeSetting, 'changeWidgetStatus'],
                [(int)$widgetInstance->getInstanceId(), true]
            );
        }
    }

    /**
     * @return array|string[]
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @return array|string[]
     */
    public static function getDependencies(): array
    {
        return [];
    }
}
