<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Model\OptionSource;

use Magento\Framework\Data\OptionSourceInterface;

class Status implements OptionSourceInterface
{
    public const SCHEDULED = 0;

    public const ACTIVE = 1;

    public const STOPPED = 2;

    public const EXPIRED = 3;

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            [
                'value' => self::SCHEDULED,
                'label' => __('Scheduled')
            ],
            [
                'value' => self::ACTIVE,
                'label' => __('Active')
            ],
            [
                'value' => self::STOPPED,
                'label' => __('Stopped')
            ],
            [
                'value' => self::EXPIRED,
                'label' => __('Expired')
            ],
        ];
    }
}
