<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Model;

class ConfigProvider extends \Amasty\Base\Model\ConfigProviderAbstract
{

    public const GENERAL_GROUP = 'general/';

    public const ENABLE_FIELD = 'enable';

    /**
     * xpath prefix of module (section)
     * @var string '{section}/'
     */
    protected $pathPrefix = 'amasty_countdown/';

    /**
     * @param string $store
     *
     * @return string
     */
    public function isModuleEnable($store)
    {
        return $this->getValue(self::GENERAL_GROUP . self::ENABLE_FIELD, $store);
    }
}
