<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Model\Config;

use Magento\Framework\Option\ArrayInterface;

class Design implements ArrayInterface
{
    public const CLEAR = 'default';

    public const TRANSPARENT = 'transparent';

    public const CIRCLE = 'circle';

    public const HONEYCOMB = 'honeycomb';

    public const ROUND = 'round';

    public const PROGRESS = 'progress';

    public const ANIMATED_DESIGNS = [
        self::CIRCLE,
        self::ROUND,
        self::PROGRESS
    ];

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'label' => 'Simple',
                'value' => [
                    [
                        'label' => 'Clear',
                        'value' => self::CLEAR
                    ],
                    [
                        'label' => 'Round',
                        'value' => self::CIRCLE
                    ],
                    [
                        'label' => 'Honeycomb',
                        'value' => self::HONEYCOMB
                    ],
                    [
                        'label' => 'Transparent',
                        'value' => self::TRANSPARENT
                    ],
                ]
            ],
            [
                'label' => 'Round',
                'value' => self::ROUND
            ],
            [
                'label' => 'Progress Bar',
                'value' => self::PROGRESS
            ],
        ];
    }
}
