<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Model;

use Magento\Framework\Message\ManagerInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance as WidgetResource;
use Magento\Widget\Model\Widget\InstanceFactory;

class Active
{
    /**
     * @var InstanceFactory
     */
    private $instanceFactory;

    /**
     * @var WidgetResource
     */
    private $widgetResource;

    /**
     * @var ManagerInterface
     */
    private $messageManager;

    public function __construct(
        ManagerInterface $messageManager,
        InstanceFactory $instanceFactory,
        WidgetResource $widgetResource
    ) {
        $this->messageManager = $messageManager;
        $this->instanceFactory = $instanceFactory;
        $this->widgetResource = $widgetResource;
    }

    /**
     * @param int $widgetId
     * @param bool $isActive
     */
    public function changeWidgetStatus(int $widgetId, bool $isActive): void
    {
        $widget = $this->instanceFactory->create();
        $this->widgetResource->load($widget, $widgetId, 'instance_id');
        $widgetOptions = $widget->getWidgetParameters();
        $widgetOptions['am_countdown_active'] = $isActive;
        $widget->setWidgetParameters($widgetOptions);
        if ($pageGroups = $widget->getPageGroups()) {
            $newPageGroups = $this->restructurePageGroups($pageGroups);
            $widget->setPageGroups($newPageGroups);
        }
        try {
            $this->widgetResource->save($widget);
        } catch (\Exception $exception) {
            $this->messageManager->addExceptionMessage(
                $exception,
                __('Can\'t save widget.')
            );
        }
    }

    /**
     * For saving widget's Layout Updates. See \Magento\Widget\Model\Widget\Instance::beforeSave()
     *
     * @param array $pageGroups
     * @return array
     */
    private function restructurePageGroups(array $pageGroups): array
    {
        $result = [];
        foreach ($pageGroups as $pageGroup) {
            if (!isset($pageGroup[$pageGroup['page_group']])) {
                $newPageGroup = [];
                $newPageGroup['page_id'] = $pageGroup['page_id'];
                $newPageGroup['layout_handle'] = $pageGroup['layout_handle'];
                $newPageGroup['entities'] = $pageGroup['entities'];
                $newPageGroup['block'] = $pageGroup['block_reference'];
                $newPageGroup['for'] = $pageGroup['page_for'];
                $newPageGroup['template'] = $pageGroup['page_template'];
                $pageGroup[$pageGroup['page_group']] = $newPageGroup;
            }
            $result[] = $pageGroup;
        }

        return $result;
    }
}
