<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Controller\Adminhtml\Instance;

use Amasty\PromoCountdown\Controller\Adminhtml\AbstractInstance;
use Amasty\PromoCountdown\Model\Active;
use Amasty\PromoCountdown\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Ui\Component\MassAction\Filter;

class MassDisable extends AbstractInstance implements HttpPostActionInterface
{
    /**
     * @var Filter
     */
    private $filter;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var Active
     */
    private $activeSetting;

    public function __construct(
        Context $context,
        Filter $filter,
        Active $activeSetting,
        CollectionFactory $collectionFactory
    ) {
        parent::__construct($context);
        $this->filter = $filter;
        $this->activeSetting = $activeSetting;
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $recordEnabled = 0;

        try {
            foreach ($collection->getItems() as $record) {
                $this->activeSetting->changeWidgetStatus((int) $record->getInstanceId(), false);
                $recordEnabled++;
            }
        } catch (\Exception $exception) {
            $this->messageManager->addExceptionMessage(
                $exception,
                __('Can\'t disable some items. Please review the log and try again.')
            );
        }

        if ($recordEnabled) {
            $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been disabled.', $recordEnabled));
        }

        return $this->resultRedirectFactory->create()
            ->setPath('*/*/');
    }
}
