<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Countdown Timer for Magento 2
 */

namespace Amasty\PromoCountdown\Block\Adminhtml\Widgets\Config;

class Toggle extends \Magento\Backend\Block\Template
{
    /**
     * @var \Magento\Framework\Data\Form\Element\Factory
     */
    private $elementFactory;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Data\Form\Element\Factory $elementFactory,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->elementFactory = $elementFactory;
    }

    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element Form Element
     *
     * @return \Magento\Framework\Data\Form\Element\AbstractElement
     */
    public function prepareElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        /** @var \Magento\Framework\Data\Form\Element\Checkbox $checkbox */
        $checkbox = $this->elementFactory->create('checkbox', ['data' => $element->getData()]);
        $checkbox->setName($element->getName());
        $checkbox->setId($element->getId());
        $checkbox->setForm($element->getForm());
        $checkbox->setClass("widget-option admin__actions-switch-checkbox");
        $checkbox->setIsChecked($element->getValue());
        $html = '<div class="admin__actions-switch" data-role="switcher">';
        $html .= $checkbox->getElementHtml();

        $html .= '<label class="admin__actions-switch-label" for=' . $element->getId() . '>
            </label>
            </div>
            <script type="text/javascript">
                require(["jquery"], function($){
                    $("#' . $element->getId() . '").change(function() {
                        if($("#' . $element->getId() . '").is(":checked")) {
                            $("#' . $element->getId() . '").val("1");
                        } else {
                            $("#' . $element->getId() . '").val("0");
                        }
                    });
                });
            </script>';

        $element->setData('after_element_html', $html);

        return $element;
    }
}
