<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\ViewModel;

use Amasty\Label\Model\ConfigProvider;
use Amasty\Label\Plugin\Product\View\Type\Configurable;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class ConfigViewModel implements ArgumentInterface
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(UrlInterface $urlBuilder, ConfigProvider $configProvider)
    {
        $this->urlBuilder = $urlBuilder;
        $this->configProvider = $configProvider;
    }

    public function getConfigurableReloadUrl(): string
    {
        return $this->urlBuilder->getUrl(Configurable::LABEL_RELOAD);
    }

    public function getProductListContainerPath(): string
    {
        return $this->configProvider->getProductListContainerPath();
    }

    public function getProductContainerPath(): string
    {
        return $this->configProvider->getProductContainerPath();
    }

    public function isShowSeveralOnPlace(): bool
    {
        return $this->configProvider->isShowSeveralOnPlace();
    }

    public function getMarginBetween(): int
    {
        return $this->configProvider->getMarginBetween();
    }
}
