<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Label\Plugin\Catalog\Product\ListProduct;

use Amasty\Label\Plugin\Catalog\Product\ListProduct;
use Hyva\Theme\Service\CurrentTheme;

class DisableListProductPluginInHyva
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * @param ListProduct $subject
     * @param callable $proceed
     * @param $originalSubject
     * @param string $result
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundAfterToHtml(ListProduct $subject, callable $proceed, $originalSubject, string $result): string
    {
        if ($this->currentTheme->isHyva()) {
            return $result;
        }

        return $proceed($originalSubject, $result);
    }
}
