<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Label\Plugin\Catalog\Product\Label;

use Amasty\Label\Plugin\Catalog\Product\Label;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Catalog\Block\Product\Image as ProductImage;

class DisableLabelPluginInHyva
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * @param Label $subject
     * @param callable $proceed
     * @param ProductImage $originalSubject
     * @param $result
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundAfterToHtml(Label $subject, callable $proceed, ProductImage $originalSubject, $result): string
    {
        if ($this->currentTheme->isHyva()) {
            return $result;
        }

        return $proceed($originalSubject, $result);
    }
}
