<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Hyva\Widgets\ViewModel\CategoryProducts;

use Amasty\ProductLabelsHyva\Model\ProductCollectionCache;
use Hyva\Widgets\ViewModel\CategoryProducts;
use Magento\Catalog\Model\ResourceModel\Product\Collection;

class CacheCollection
{
    /**
     * @var ProductCollectionCache
     */
    private ProductCollectionCache $productCollectionCache;
    public function __construct(
        ProductCollectionCache $productCollectionCache
    ) {
        $this->productCollectionCache = $productCollectionCache;
    }

    public function afterGetProductCollection(
        CategoryProducts $subject,
        Collection $result,
        $categoryId,
        $sortBy = null,
        $sortDirection = null,
        int $limit = CategoryProducts::DEFAULT_LIMIT
    ): Collection {
        $key = sprintf('%s_%s_%s_%d', $categoryId, $sortBy, $sortDirection, $limit);
        $this->productCollectionCache->add($result, $key);
        return $result;
    }
}
