<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Hyva\Widgets\Block\Widgets\Category;

use Amasty\Base\Model\Serializer;
use Amasty\Label\Model\LabelViewer;
use Amasty\ProductLabelsHyva\Model\ProductCollectionCache;
use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\Framework\View\Element\Template;

class AddLabelToWidget
{
    /**
     * @var LabelViewer
     */
    private LabelViewer $labelViewer;

    /**
     * @var ProductCollectionCache
     */
    private ProductCollectionCache $productCollectionCache;

    /**
     * @var Serializer
     */
    private Serializer $serializer;

    public function __construct(
        LabelViewer $labelViewer,
        ProductCollectionCache $productCollectionCache,
        Serializer $serializer
    ) {
        $this->labelViewer = $labelViewer;
        $this->productCollectionCache = $productCollectionCache;
        $this->serializer = $serializer;
    }

    public function afterToHtml(Template $subject, string $result): string
    {
        $productCollection = $this->getProductCollection($subject);
        if (empty($productCollection)) {
            return $result;
        }

        $labels = $this->generateProductsLabels($productCollection);
        $block = $subject->getLayout()->createBlock(Template::class)
            ->setNameInLayout('amlabel.widget' . uniqid())
            ->setTemplate('Amasty_ProductLabelsHyva::page/widget-labels.phtml')
            ->setData([
                'display_type' => $subject->getData('hyva_category_type'),
                'labels' => $this->serializer->serialize($labels)
            ]);

        $result .= $block->toHtml();

        return $result;
    }

    private function getProductCollection(Template $subject): ?Collection
    {
        $key = $this->getCollectionCacheKey($subject);

        return $this->productCollectionCache->has($key)
            ? $this->productCollectionCache->get($key)
            : null;
    }

    private function getCollectionCacheKey(Template $subject): string
    {
        return sprintf(
            '%s_%s_%s_%d',
            $subject->getData('hyva_category_list'),
            $subject->getData('hyva_category_sort_by'),
            $subject->getData('hyva_category_sort_direction'),
            $subject->getData('hyva_category_limit')
        );
    }

    private function generateProductsLabels(Collection $productCollection): array
    {
        $labels = [];

        foreach ($productCollection as $product) {
            $labels[] = $this->labelViewer->renderProductLabel($product);
        }

        return $labels;
    }
}
