<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Hyva\Theme\ViewModel;

use Amasty\Label\Model\LabelViewer;
use Amasty\Label\Model\ResourceModel\Label\Collection;
use Hyva\Theme\ViewModel\ProductListItem;
use Magento\Catalog\Model\Product;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\AbstractBlock;

class AddLabel
{
    /**
     * @var LabelViewer
     */
    private LabelViewer $labelViewer;

    /**
     * @var Registry
     */
    private Registry $registry;

    public function __construct(
        LabelViewer $labelViewer,
        Registry $registry
    ) {
        $this->labelViewer = $labelViewer;
        $this->registry = $registry;
    }

    /**
     * @param ProductListItem $subject
     * @param string $result
     * @param AbstractBlock $itemRendererBlock
     * @param Product $product
     * @return string
     * @throws LocalizedException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetItemHtmlWithRenderer(
        ProductListItem $subject,
        string $result,
        AbstractBlock $itemRendererBlock,
        Product $product
    ): string {
        if ($this->registry->registry('amlabel_category_observer')) {
            return $result;
        }

        $result .= $this->labelViewer->renderProductLabel($product, Collection::MODE_LIST);

        return $result;
    }
}
