<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Plugin\Block;

use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\View\Element\Template;

class ChangeTemplate
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    public function __construct(CurrentTheme $currentTheme)
    {
        $this->currentTheme = $currentTheme;
    }

    /**
     * @param Template $subject
     * @param string $result
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetTemplate(Template $subject, string $result): string
    {
        if ($this->currentTheme->isHyva()) {
            return str_replace('Amasty_Label::', 'Amasty_ProductLabelsHyva::', (string)$result);
        }

        return $result;
    }
}
