<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels compatibility with Hyva Theme
 */

namespace Amasty\ProductLabelsHyva\Model;

use Magento\Catalog\Model\ResourceModel\Product\Collection;

class ProductCollectionCache
{
    /**
     * @var array
     */
    private array $cache = [];

    public function get(string $key)
    {
        return $this->cache[$key] ?? null;
    }

    public function has(string $key): bool
    {
        return isset($this->cache[$key]);
    }

    public function add(Collection $collection, $key): void
    {
        $this->cache[$key] = $collection;
    }
}
