<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Import Entity for Magento 2 (System)
 */

namespace Amasty\ProductImportEntity\Import\Validation\RowValidator\Product\CustomOption;

use Amasty\ImportCore\Api\Validation\RowValidatorInterface;

class CustomOptionValueValidator implements RowValidatorInterface
{
    /**
     * @var string|null
     */
    private $message;

    /**
     * @inheritDoc
     */
    public function validate(array $row): bool
    {
        $this->message = null;

        if (!isset($row['option_type_id'])) {
            $this->message = (string)__('\'option_type_id\' value is missing in Product Custom Option data.');

            return false;
        }

        if (!isset($row['option_id'])) {
            $this->message = (string)__('\'option_id\' value is missing in Product Custom Option data.');

            return false;
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }
}
