<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Import Entity for Magento 2 (System)
 */

namespace Amasty\ProductImportEntity\Import\Validation\EntityValidator\Product;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Catalog\Model\ResourceModel\Product as ProductResource;

class DuplicateSku implements FieldValidatorInterface
{
    /**
     * @var ProductResource
     */
    private $productResource;

    /**
     * @var array
     */
    private $validationResult;

    public function __construct(ProductResource $productResource)
    {
        $this->productResource = $productResource;
    }

    /**
     * @inheritDoc
     */
    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $sku = trim($row[$field]);

            if (!empty($sku)) {
                if (!isset($this->validationResult[$sku])) {
                    $this->validationResult[$sku] = $this->productResource->getIdBySku($sku) === false;
                }

                return $this->validationResult[$sku];
            }
        }

        return true;
    }
}
