<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Import Entity for Magento 2 (System)
 */

namespace Amasty\ProductImportEntity\Import\Behavior\Product\AddUpdate;

use Amasty\ImportCore\Api\Behavior\BehaviorResultInterface;
use Amasty\ImportCore\Import\Behavior\AddUpdate\Table as AddUpdateDirect;

class ProductEntity extends AddUpdateDirect
{
    /**
     * @inheritDoc
     */
    public function execute(array &$data, ?string $customIdentifier = null): BehaviorResultInterface
    {
        $this->offForeignKeysCheck();
        try {
            $result = parent::execute($data, $customIdentifier);
            $this->onForeignKeysCheck();
        } catch (\Exception $e) {
            $this->onForeignKeysCheck();
            throw $e;
        }

        return $result;
    }

    private function offForeignKeysCheck()
    {
        $this->getConnection()->query('SET FOREIGN_KEY_CHECKS = 0;');
    }

    private function onForeignKeysCheck()
    {
        $this->getConnection()->query('SET FOREIGN_KEY_CHECKS = 1;');
    }
}
