<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Export Entity for Magento 2 (System)
 */

namespace Amasty\ProductExportEntity\Model\ResourceModel\Product\Type\Configurable\Attribute\Label;

use Amasty\ProductExportEntity\Export\Product\Type\Configurable\ScopedEntity\Attribute\LabelCollector;
use Amasty\ProductExportEntity\Model\ResourceModel\ScopedEntity\Collection\Field\ArgumentProcessor;
use Amasty\ProductExportEntity\Model\ResourceModel\ScopedEntityCollection;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Store\Model\StoreManagerInterface;

class ScopedCollection extends ScopedEntityCollection
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        EntityFactoryInterface $entityFactory,
        StoreManagerInterface $storeManager,
        LabelCollector $itemCollector,
        CollectionFactory $collectionFactory,
        ArgumentProcessor $fieldArgumentProcessor
    ) {
        parent::__construct(
            $entityFactory,
            $storeManager,
            $itemCollector,
            $fieldArgumentProcessor
        );
        $this->collectionFactory = $collectionFactory;
    }

    protected function getScopeFieldName()
    {
        return LabelCollector::STORE_ID_FIELD;
    }

    protected function getCollectionFactory()
    {
        return $this->collectionFactory;
    }

    protected function getRedundantFields()
    {
        $redundantFields = parent::getRedundantFields();
        $redundantFields[] = 'product_super_attribute_id';
        return $redundantFields;
    }
}
