<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Export Entity for Magento 2 (System)
 */

namespace Amasty\ProductExportEntity\Export\DataHandling\FieldModifier\Customer;

use Amasty\ProductExportEntity\Export\DataHandling\FieldModifier\SourceOption\Value2Label;
use Amasty\ExportCore\Export\SourceOption\CustomerGroupOptions;

class GroupId2GroupCode extends Value2Label
{
    /**
     * @var CustomerGroupOptions
     */
    private $sourceModel;

    public function __construct($config, CustomerGroupOptions $sourceModel)
    {
        parent::__construct($config);
        $this->sourceModel = $sourceModel;
    }

    protected function getSourceModel()
    {
        return $this->sourceModel;
    }

    public function getLabel(): string
    {
        return __('Convert Group Id To Group Code')->getText();
    }
}
