<?php
declare(strict_types=1);

namespace Amasty\ProductAttachmentGraphQl\Model\Resolver;

use Amasty\ProductAttachment\Model\ConfigProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetSettings implements ResolverInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        return [
            'isEnabled' => $this->configProvider->isEnabled(),
            'addCategoryFilesToProducts' => $this->configProvider->addCategoriesFilesToProducts(),
            'displayInOrderFiles' => $this->configProvider->excludeIncludeInOrderFiles(),
            'urlCreationType' => $this->configProvider->getUrlType(),
            'isShowProductAttachmentTab' => $this->configProvider->isBlockEnabled(),
            'productAttachmentTabTitle' => $this->configProvider->getBlockTitle(),
            'productAttachmentTabCustomerGroups' => $this->getCustomerGroups(),
            'showFileIcon' => $this->configProvider->isShowIcon(),
            'showFileSize' => $this->configProvider->isShowFilesize(),
            'productAttachmentTabPosition' => $this->configProvider->getBlockSortOrder(),
            'isShowInOrderView' => $this->configProvider->isShowInOrderView(),
            'orderViewAttachmentsTitle' => $this->configProvider->getLabelInOrderView(),
            'orderViewAttachmentsType' => $this->configProvider->getViewAttachmentsFilter(),
            'orderViewStatuses' => $this->configProvider->getViewOrderStatuses(),
            'showFileIconOrder' => $this->configProvider->isShowIconInOrderView(),
            'showFileSizeOrder' => $this->configProvider->isShowFilesizeInOrderView()
        ];
    }

    private function getCustomerGroups(): array
    {
        if ($this->configProvider->getBlockCustomerGroups()) {
            return array_map('trim', explode(',', $this->configProvider->getBlockCustomerGroups()));
        }

        return [];
    }
}
