<?php
declare(strict_types=1);

namespace Amasty\ProductAttachmentGraphQl\Model\Resolver;

use Amasty\ProductAttachmentApi\Api\FrontendAttachmentInterface;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetFiles implements ResolverInterface
{
    /**
     * @var FrontendAttachmentInterface
     */
    private $frontendAttachment;

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    public function __construct(
        FrontendAttachmentInterface $frontendAttachment,
        GetCustomer $getCustomer
    ) {
        $this->frontendAttachment = $frontendAttachment;
        $this->getCustomer = $getCustomer;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $ids = $args['ids'] ?? [];
        if (empty($ids)) {
            throw new GraphQlInputException(__('File ID\'s must be specified.'));
        }

        if ($context->getUserId()) {
            $groupId = $this->getCustomer->execute($context)->getGroupId();
        } else {
            $groupId = 0;
        }

        return $this->frontendAttachment->getByFileIds(
            $ids,
            [],
            false,
            $groupId
        );
    }
}
