<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Attachments MFTF 3 for Magento 2 (System)
 */

namespace Amasty\ProductAttachmentMFTF3\Console\Command;

use Magento\Framework\Console\Cli;
use Magento\Framework\ObjectManagerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\App\RequestInterface;
use Amasty\ProductAttachment\Controller\Adminhtml\Import\Generate;

class GenerateMassImportFile extends Command
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var State
     */
    private $state;

    public function __construct(
        RequestInterface $request,
        ObjectManagerInterface $objectManager,
        State $state
    )
    {
        parent::__construct();
        $this->request = $request;
        $this->objectManager = $objectManager;
        $this->state = $state;
    }

    protected function configure()
    {
        $this->setName('mftf:prod-attach:generate-import');
        $this->setDefinition(
            [
                new InputArgument(
                    'id',
                    InputArgument::REQUIRED,
                    'import_id'
                ),
                new InputArgument(
                    'file_name',
                    InputArgument::REQUIRED,
                    'New Name Generated File'
                )
            ]
        );
        parent::configure();
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $importId = (string)$input->getArgument('id');
        $name = (string)$input->getArgument('file_name');

        $this->state->setAreaCode(Area::AREA_ADMINHTML);
        $this->request->setParams(['import_id' => $importId]);

        $generate = $this->objectManager->create(Generate::class);
        $raw = $generate->execute();

        $ref = new \ReflectionClass($raw);
        $content = $ref->getProperty('contents')->getValue($raw);

        file_put_contents(MAGENTO_BP . '/dev/tests/acceptance/tests/_data/' . $name, $content);

        $output->writeln('<info>Script is finished!".</info>');

        return Cli::RETURN_SUCCESS;
    }
}
