<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Attachments MFTF 3 for Magento 2 (System)
 */

namespace Amasty\ProductAttachmentMFTF3\Console\Command;

use Amasty\ProductAttachment\Api\FileRepositoryInterface;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;

class CrashAttachmentLink extends Command
{

    /**
     * @var FileRepositoryInterface
     */
    private $fileRepostory;

    public function __construct(
        FileRepositoryInterface $fileRepository
    ) {
        $this->fileRepostory = $fileRepository;
        parent::__construct();
    }

    protected function configure(): void
    {
        $this->setName('mftf:prod-attach:crash-link');
        $this->setDefinition(
            [
                new InputArgument(
                    'id',
                    InputArgument::REQUIRED,
                    'Attachment ID'
                ),
                new InputArgument(
                    'new_link',
                    InputArgument::REQUIRED,
                    'Crash Link'
                )
            ]
        );
        parent::configure();
    }

    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $attachId = (int)$input->getArgument('id');
        $newLink = (string)$input->getArgument('new_link');

        $attach = $this->fileRepostory->getById($attachId);
        $attach->setLink($newLink);
        $attach->save();

        $output->writeln('<info>Script is finished!".</info>');

        return Cli::RETURN_SUCCESS;
    }
}
