<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Pre Order Analytics for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\PreOrderAnalytic\Model\ResourceModel;

use Amasty\Preorder\Api\Data\OrderInformationInterface;
use Magento\Framework\App\ResourceConnection;

class LoadUniquePreorderCustomers
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var ApplyFilterParams
     */
    private $applyFilterParams;

    public function __construct(ResourceConnection $resourceConnection, ApplyFilterParams $applyFilterParams)
    {
        $this->resourceConnection = $resourceConnection;
        $this->applyFilterParams = $applyFilterParams;
    }

    public function execute(array $params): int
    {
        $connection = $this->resourceConnection->getConnection('sales');
        $select = $connection->select()->from(
            ['sales_order' => $this->resourceConnection->getTableName('sales_order')],
            ['COUNT(DISTINCT customer_email)']
        )->join(
            ['order_preorder' => $this->resourceConnection->getTableName(OrderInformationInterface::MAIN_TABLE)],
            'sales_order.entity_id = order_preorder.order_id',
            []
        );
        $this->applyFilterParams->execute($select, $params);

        return (int) $connection->fetchOne($select);
    }
}
