<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Hyva Compatibility by Amasty
 */

namespace Amasty\PageSpeedOptimizerHyva\Model\Image;

use Amasty\ImageOptimizer\Model\Image\ReplacePatterns\Img as ImageOptimizerImg;
use Amasty\LazyLoad\Model\Image\ReplacePatterns\Img as LazyLoadImg;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;

class ReplacePatternGroupsPool extends \Amasty\PageSpeedTools\Model\Image\ReplacePatternGroupsPool
{
    public const PATTERN = '<img\s*(?:%img_attributes%|'
    . '(?<any>[a-z\-_]+\s*\=\s*[\'\"](.*?)[\'\"].*?\s*)'
    . '|(?<hyva>[\:\@]+[a-z0-9\.\-]+\s*\=\s*[\"](.*?)[\"].*?\s*)'
    . ')+.*?>';

    /**
     * @var Manager
     */
    private $manager;

    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    public function __construct(
        Manager $manager,
        ObjectManagerInterface $objectManager,
        array $replacePatternGroups = []
    ) {
        $this->manager = $manager;
        $this->objectManager = $objectManager;

        $this->modifyPatternGroups($replacePatternGroups);
        parent::__construct($replacePatternGroups);
    }

    private function modifyPatternGroups(array &$groups): void
    {
        if (!$this->objectManager->get(CurrentTheme::class)->isHyva()) {
            return;
        }

        if (isset($groups['image_optimizer']['img']) && $this->manager->isEnabled('Amasty_ImageOptimizer')) {
            $groups['image_optimizer']['img'] = $this->objectManager->create(
                ImageOptimizerImg::class,
                ['pattern' => static::PATTERN]
            );
        }

        if (isset($groups['lazy_load']['img']) && $this->manager->isEnabled('Amasty_LazyLoad')) {
            $groups['lazy_load']['img'] = $this->objectManager->create(
                LazyLoadImg::class,
                ['pattern' => static::PATTERN]
            );
        }
    }
}
